(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     17939,        582]*)
(*NotebookOutlinePosition[     18782,        609]*)
(*  CellTagsIndexPosition[     18738,        605]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(\(\( (*\ 
      Example\ 2.2 \( \(.2\)\(.\)\)\ *) \)\(\[IndentingNewLine]\)\(\[Psi][
        1, \ x_] := \ 
      Sin[\[Pi]\ x]; \[Psi]2[
        x] = \((1/
              2)\)\ \((\ \((2 - x)\)*
                Integrate[\ s\ *Sin[\[Pi]\ s], \ {s, 0, x}] + \n\t\t\t\tx*
                Integrate[\ \((2 - s)\)\ *Sin[\[Pi]\ s], \ {s, x, 1}])\) // 
        Simplify\)\)\)], "Input"],

Cell[BoxData[
    \(\(\[Pi]\ x + 2\ Sin[\[Pi]\ x]\)\/\(2\ \[Pi]\^2\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Psi]3[x] = 
      \((1/2)\)\ 
          \((\ \((2 - x)\)*
                Integrate[\ 
                  s\ *\(\[Pi]\ s + 2\ Sin[\[Pi]\ s]\)\/\(2\ \[Pi]\^2\), 
                  \ {s, 0, x}] + \n\t\t\t\t
              x*Integrate[\ 
                  \((2 - s)\)\ *
                    \(\[Pi]\ s + 2\ Sin[\[Pi]\ s]\)\/\(2\ \[Pi]\^2\), 
                  \ {s, x, 1}])\) // Simplify\)], "Input"],

Cell[BoxData[
    \(\(\[Pi]\ x\ \((6 + 2\ \[Pi]\^2 - \[Pi]\^2\ x\^2)\) + 
        12\ Sin[\[Pi]\ x]\)\/\(12\ \[Pi]\^4\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Psi]4[x] = 
      \((1/2)\)\ 
          \((\ \((2 - x)\)*
                Integrate[\ 
                  s\ *\(\[Pi]\ s\ \((6 + 2\ \[Pi]\^2 - \[Pi]\^2\ s\^2)\) + 
                        12\ Sin[\[Pi]\ s]\)\/\(12\ \[Pi]\^4\), \ {s, 0, x}] + 
              \n\t\t\t\t
              x*Integrate[\ 
                  \((2 - s)\)\ *
                    \(\[Pi]\ s\ \((6 + 2\ \[Pi]\^2 - \[Pi]\^2\ s\^2)\) + 
                        12\ Sin[\[Pi]\ s]\)\/\(12\ \[Pi]\^4\), \ {s, x, 1}])
            \) // Simplify\)], "Input"],

Cell[BoxData[
    \(\(\[Pi]\ x\ 
          \((360 + 120\ \[Pi]\^2 + 31\ \[Pi]\^4 - 
              20\ \[Pi]\^2\ \((3 + \[Pi]\^2)\)\ x\^2 + 3\ \[Pi]\^4\ x\^4)\) + 
        720\ Sin[\[Pi]\ x]\)\/\(720\ \[Pi]\^6\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Psi]5[x] = 
      \((1/2)\)\ 
          \((\ \((2 - x)\)*
                Integrate[\ 
                  s\ *\(1\/\(720\ \[Pi]\^6\)\) 
                    \((\[Pi]\ s\ 
                          \((360 + 120\ \[Pi]\^2 + 31\ \[Pi]\^4 - 
                              20\ \[Pi]\^2\ \((3 + \[Pi]\^2)\)\ s\^2 + 
                              3\ \[Pi]\^4\ s\^4)\) + 720\ Sin[\[Pi]\ s])\), 
                  \ {s, 0, x}] + \n\t\t\t\t
              x*Integrate[\ 
                  \((2 - s)\)\ *\(1\/\(720\ \[Pi]\^6\)\) 
                    \((\[Pi]\ s\ 
                          \((360 + 120\ \[Pi]\^2 + 31\ \[Pi]\^4 - 
                              20\ \[Pi]\^2\ \((3 + \[Pi]\^2)\)\ s\^2 + 
                              3\ \[Pi]\^4\ s\^4)\) + 720\ Sin[\[Pi]\ s])\), 
                  \ {s, x, 1}])\) // Simplify\)], "Input"],

Cell[BoxData[
    \(\(1\/\(30240\ \[Pi]\^8\)\((
      \[Pi]\ x\ \((
            15120 + 5040\ \[Pi]\^2 + 1302\ \[Pi]\^4 + 320\ \[Pi]\^6 - 
              7\ \[Pi]\^2\ \((360 + 120\ \[Pi]\^2 + 31\ \[Pi]\^4)\)\ x\^2 + 
              42\ \[Pi]\^4\ \((3 + \[Pi]\^2)\)\ x\^4 - 3\ \[Pi]\^6\ x\^6)\) + 
        30240\ Sin[\[Pi]\ x])\)\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(a11 = NIntegrate[Sin[\[Pi]\ x]*Sin[\[Pi]\ x], \ {x, 0, 1}]\)], "Input"],

Cell[BoxData[
    \(0.5`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(a12 = 
      NIntegrate[
        Sin[\[Pi]\ x]*\(\[Pi]\ x + 2\ Sin[\[Pi]\ x]\)\/\(2\ \[Pi]\^2\), 
        \ {x, 0, 1}]\)], "Input"],

Cell[BoxData[
    \(0.101321183642337775`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(a13 = 
      NIntegrate[
        Sin[\[Pi]\ x]*
          \(\[Pi]\ x\ \((6 + 2\ \[Pi]\^2 - \[Pi]\^2\ x\^2)\) + 
              12\ Sin[\[Pi]\ x]\)\/\(12\ \[Pi]\^4\), \ {x, 0, 1}]\)], "Input"],

Cell[BoxData[
    \(0.0238424053522213208`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(a14 = 
      NIntegrate[
        Sin[\[Pi]\ x]*
          \(1\/\(720\ \[Pi]\^6\)\((
            \[Pi]\ x\ 
                \((360 + 120\ \[Pi]\^2 + 31\ \[Pi]\^4 - 
                    20\ \[Pi]\^2\ \((3 + \[Pi]\^2)\)\ x\^2 + 
                    3\ \[Pi]\^4\ x\^4)\) + 720\ Sin[\[Pi]\ x])\)\), 
        \ {x, 0, 1}]\)], "Input"],

Cell[BoxData[
    \(0.00576145411541788465`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(a15 = 
      NIntegrate[
        Sin[\[Pi]\ x]*\(1\/\(30240\ \[Pi]\^8\)\) 
          \((\[Pi]\ x\ 
                \((15120 + 5040\ \[Pi]\^2 + 1302\ \[Pi]\^4 + 320\ \[Pi]\^6 - 
                    7\ \[Pi]\^2\ \((360 + 120\ \[Pi]\^2 + 31\ \[Pi]\^4)\)\ 
                      x\^2 + 42\ \[Pi]\^4\ \((3 + \[Pi]\^2)\)\ x\^4 - 
                    3\ \[Pi]\^6\ x\^6)\) + 30240\ Sin[\[Pi]\ x])\), 
        \ {x, 0, 1}]\)], "Input"],

Cell[BoxData[
    \(0.00139852968107941499`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(a22 = 
      NIntegrate[
        \(\[Pi]\ x + 2\ Sin[\[Pi]\ x]\)\/\(2\ \[Pi]\^2\)*
          \(\[Pi]\ x + 2\ Sin[\[Pi]\ x]\)\/\(2\ \[Pi]\^2\), \ {x, 0, 1}]\)], 
  "Input"],

Cell[BoxData[
    \(0.0238424053522213252`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(a23 = 
      NIntegrate[
        \(\[Pi]\ x + 2\ Sin[\[Pi]\ x]\)\/\(2\ \[Pi]\^2\)*
          \(\[Pi]\ x\ \((6 + 2\ \[Pi]\^2 - \[Pi]\^2\ x\^2)\) + 
              12\ Sin[\[Pi]\ x]\)\/\(12\ \[Pi]\^4\), \ {x, 0, 1}]\)], "Input"],

Cell[BoxData[
    \(0.00576145411541788465`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(a24 = 
      NIntegrate[
        \(\[Pi]\ x + 2\ Sin[\[Pi]\ x]\)\/\(2\ \[Pi]\^2\)*
          \(1\/\(720\ \[Pi]\^6\)\) 
          \((\[Pi]\ x\ 
                \((360 + 120\ \[Pi]\^2 + 31\ \[Pi]\^4 - 
                    20\ \[Pi]\^2\ \((3 + \[Pi]\^2)\)\ x\^2 + 
                    3\ \[Pi]\^4\ x\^4)\) + 720\ Sin[\[Pi]\ x])\), \ {x, 0, 1}]
        \)], "Input"],

Cell[BoxData[
    \(0.00139852968107941499`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(a25 = 
      NIntegrate[
        \(\[Pi]\ x + 2\ Sin[\[Pi]\ x]\)\/\(2\ \[Pi]\^2\)*
          \(1\/\(30240\ \[Pi]\^8\)\) 
          \((\[Pi]\ x\ 
                \((15120 + 5040\ \[Pi]\^2 + 1302\ \[Pi]\^4 + 320\ \[Pi]\^6 - 
                    7\ \[Pi]\^2\ \((360 + 120\ \[Pi]\^2 + 31\ \[Pi]\^4)\)\ 
                      x\^2 + 42\ \[Pi]\^4\ \((3 + \[Pi]\^2)\)\ x\^4 - 
                    3\ \[Pi]\^6\ x\^6)\) + 30240\ Sin[\[Pi]\ x])\), 
        \ {x, 0, 1}]\)], "Input"],

Cell[BoxData[
    \(0.000339737298327543157`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(a33 = 
      NIntegrate[
        \(\[Pi]\ x\ \((6 + 2\ \[Pi]\^2 - \[Pi]\^2\ x\^2)\) + 
              12\ Sin[\[Pi]\ x]\)\/\(12\ \[Pi]\^4\)*
          \(\[Pi]\ x\ \((6 + 2\ \[Pi]\^2 - \[Pi]\^2\ x\^2)\) + 
              12\ Sin[\[Pi]\ x]\)\/\(12\ \[Pi]\^4\), \ {x, 0, 1}]\)], "Input"],

Cell[BoxData[
    \(0.00139852968107941567`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(a34 = 
      NIntegrate[
        \(\[Pi]\ x\ \((6 + 2\ \[Pi]\^2 - \[Pi]\^2\ x\^2)\) + 
              12\ Sin[\[Pi]\ x]\)\/\(12\ \[Pi]\^4\)*\(1\/\(720\ \[Pi]\^6\)\) 
          \((\[Pi]\ x\ 
                \((360 + 120\ \[Pi]\^2 + 31\ \[Pi]\^4 - 
                    20\ \[Pi]\^2\ \((3 + \[Pi]\^2)\)\ x\^2 + 
                    3\ \[Pi]\^4\ x\^4)\) + 720\ Sin[\[Pi]\ x])\), \ {x, 0, 1}]
        \)], "Input"],

Cell[BoxData[
    \(0.000339737298327542847`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(a35 = 
      NIntegrate[
        \(\[Pi]\ x\ \((6 + 2\ \[Pi]\^2 - \[Pi]\^2\ x\^2)\) + 
              12\ Sin[\[Pi]\ x]\)\/\(12\ \[Pi]\^4\)*
          \(1\/\(30240\ \[Pi]\^8\)\) 
          \((\[Pi]\ x\ 
                \((15120 + 5040\ \[Pi]\^2 + 1302\ \[Pi]\^4 + 320\ \[Pi]\^6 - 
                    7\ \[Pi]\^2\ \((360 + 120\ \[Pi]\^2 + 31\ \[Pi]\^4)\)\ 
                      x\^2 + 42\ \[Pi]\^4\ \((3 + \[Pi]\^2)\)\ x\^4 - 
                    3\ \[Pi]\^6\ x\^6)\) + 30240\ Sin[\[Pi]\ x])\), 
        \ {x, 0, 1}]\)], "Input"],

Cell[BoxData[
    \(0.0000825412835994888816`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(a44 = 
      NIntegrate[
        \(1\/\(720\ \[Pi]\^6\)\) 
          \((\[Pi]\ x\ 
                \((360 + 120\ \[Pi]\^2 + 31\ \[Pi]\^4 - 
                    20\ \[Pi]\^2\ \((3 + \[Pi]\^2)\)\ x\^2 + 
                    3\ \[Pi]\^4\ x\^4)\) + 720\ Sin[\[Pi]\ x])\)*
          \(1\/\(720\ \[Pi]\^6\)\) 
          \((\[Pi]\ x\ 
                \((360 + 120\ \[Pi]\^2 + 31\ \[Pi]\^4 - 
                    20\ \[Pi]\^2\ \((3 + \[Pi]\^2)\)\ x\^2 + 
                    3\ \[Pi]\^4\ x\^4)\) + 720\ Sin[\[Pi]\ x])\), \ {x, 0, 1}]
        \)], "Input"],

Cell[BoxData[
    \(0.0000825412835994888816`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(a45 = 
      NIntegrate[
        \(1\/\(720\ \[Pi]\^6\)\) 
          \((\[Pi]\ x\ 
                \((360 + 120\ \[Pi]\^2 + 31\ \[Pi]\^4 - 
                    20\ \[Pi]\^2\ \((3 + \[Pi]\^2)\)\ x\^2 + 
                    3\ \[Pi]\^4\ x\^4)\) + 720\ Sin[\[Pi]\ x])\)*
          \(1\/\(30240\ \[Pi]\^8\)\) 
          \((\[Pi]\ x\ 
                \((15120 + 5040\ \[Pi]\^2 + 1302\ \[Pi]\^4 + 320\ \[Pi]\^6 - 
                    7\ \[Pi]\^2\ \((360 + 120\ \[Pi]\^2 + 31\ \[Pi]\^4)\)\ 
                      x\^2 + 42\ \[Pi]\^4\ \((3 + \[Pi]\^2)\)\ x\^4 - 
                    3\ \[Pi]\^6\ x\^6)\) + 30240\ Sin[\[Pi]\ x])\), 
        \ {x, 0, 1}]\)], "Input"],

Cell[BoxData[
    \(0.0000200543606854955491`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(p = {{0.5`, \ 0.101321183642337775`, 0.0238424053522213208`}, \n
          \t\t{0.101321183642337775`, 0.0238424053522213252`, 
            0.00576145411541788465`}}, {0.0238424053522213208`, \ 
        0.00576145411541788465`, \ 0.00139852968107941567`}}\)\)], "Input"],

Cell[BoxData[
    \({{0.5`, 0.101321183642337775`, 0.0238424053522213208`}, {
        0.101321183642337775`, 0.0238424053522213252`, 
        0.00576145411541788465`}, {0.0238424053522213208`, 
        0.00576145411541788465`, 0.00139852968107941567`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(q = 
      \(-{{0.00576145411541788465`}, 
          \ {0.00139852968107941499`}, {0.000339737298327542847`}}\)\)], 
  "Input"],

Cell[BoxData[
    \({{\(-0.00576145411541788465`\)}, {\(-0.00139852968107941499`\)}, {
        \(-0.000339737298327542847`\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(LinearSolve[p, q]\)], "Input"],

Cell[BoxData[
    \({{\(-0.000113741426928147393`\)}, {0.0132604742895668592`}, {
        \(-0.295614064458259839`\)}}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\( (*\ These\ are\ the\ values\ of\ \[Alpha]0, \ 
      \[Alpha]1\ and\ \[Alpha]2\ which\ give\ equation\ \((2.2  .1)\)\ in\ 
        \[Mu]\ *) \ \ \ \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSolve[
      \[Mu]^3\  - 0.295614064458259839`*\ \ \ \[Mu]\ ^2 + 
          0.0132604742895668592`*\ \[Mu] - 0.000113741426928147393` == \ 0]
      \)], "Input"],

Cell[BoxData[
    \({{\[Mu] \[Rule] 0.0113290623388231126`}, {
        \[Mu] \[Rule] 0.0413223699898336516`}, {
        \[Mu] \[Rule] 0.242962632129603051`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ 
      Eigenvalues\ are\ reciprocals\ of\ these\ \[Mu]\ values\ in\ reverse\ 
        order\ *) \n\n\[Lambda]1 = 1/0.242962632129603051`\)\)], "Input"],

Cell[BoxData[
    \(4.11585926294448434`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Lambda]2 = 1/0.0413223699898336516`\)], "Input"],

Cell[BoxData[
    \(24.1999672391981679`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Lambda]3 = 1/0.0113290623388231126`\)], "Input"],

Cell[BoxData[
    \(88.2685583407145557`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\( (*\ So\ far\ the\ results\ are\ for\ n = 3\ \ *) \n (*\ 
      Now\ for\ n = 4, \ 
      with\ a\ 4  x4\ system\ that\ computes\ \ the\ values\ of\ \[Alpha]0, \ 
      \[Alpha]1, \ 
      \[Alpha]2\ and\ \[Alpha]3\ which\ give\ equation\ \((2.2  .1)\)\ in\ 
        \[Mu]\ *) \n (*\ we\ shall\ write\ it\ as\ p1\ *\ \[Alpha] = q1, \ 
      and\ solve\ it*) \ \ \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(p1 = {{0.5`, \ 0.101321183642337775`, 0.0238424053522213208`, \ 
          0.00576145411541788465`}, \n
        \t\t{0.101321183642337775`, 0.0238424053522213252`, 
          0.00576145411541788465`, \ 0.00139852968107941499`}, {
          0.0238424053522213208`, \ 0.00576145411541788465`, \ 
          0.00139852968107941567`, \ 0.000339737298327542847`}, \n
        \t{0.00576145411541788465`, \ 0.00139852968107941499`, \ 
          0.000339737298327542847`, \ 0.0000825412835994888816`}}\)], "Input"],

Cell[BoxData[
    \({{0.5`, 0.101321183642337775`, 0.0238424053522213208`, 
        0.00576145411541788465`}, {0.101321183642337775`, 
        0.0238424053522213252`, 0.00576145411541788465`, 
        0.00139852968107941499`}, {0.0238424053522213208`, 
        0.00576145411541788465`, 0.00139852968107941567`, 
        0.000339737298327542847`}, {0.00576145411541788465`, 
        0.00139852968107941499`, 0.000339737298327542847`, 
        0.0000825412835994888816`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(q1 = 
      \(-{{0.00139852968107941499`}, {0.000339737298327543157`}, 
          \ {0.0000825412835994888816`}, \ {0.0000200543606854955491`}}\)\)], 
  "Input"],

Cell[BoxData[
    \({{\(-0.00139852968107941499`\)}, {\(-0.000339737298327543157`\)}, {
        \(-0.0000825412835994888816`\)}, {\(-0.0000200543606854955447`\)}}
      \)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(LinearSolve[p1, q1]\)], "Input"],

Cell[BoxData[
    \({{6.94577645063737492`*^-7}, {\(-0.000218735069584678498`\)}, {
        0.0157597612023711697`}, {\(-0.304170623159006847`\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSolve[
      \[Mu]^4\  - 0.304170623159006847`*\ \ \[Mu]\ ^3 + 
          0.0157597612023711697`*\ \[Mu]^2\  - 
          0.000218735069584678498`*\ \[Mu] + 6.94577645063737492`*^-7 == 0]
      \)], "Input"],

Cell[BoxData[
    \({{\[Mu] \[Rule] 0.00452213718575475809`}, {
        \[Mu] \[Rule] 0.0152606699601422723`}, {
        \[Mu] \[Rule] 0.0414251309288215541`}, {
        \[Mu] \[Rule] 0.24296268508428831`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ The\ eigenvalues\ are*) \nlambda1 = 1/0.24296268508428831`\)\)], 
  "Input"],

Cell[BoxData[
    \(4.11585836587655951`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(lambda2 = 1/0.0414251309288215541`\)], "Input"],

Cell[BoxData[
    \(24.1399357727617847`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(lambda3 = 1/0.0152606699601422723`\)], "Input"],

Cell[BoxData[
    \(65.5279226018119764`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(lambda4 = 1/0.00452213718575475809`\)], "Input"],

Cell[BoxData[
    \(221.134379370469513`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(psi5[x] = 
      Apart[\(1\/\(30240\ \[Pi]\^8\)\) 
          \((\[Pi]\ x\ 
                \((15120 + 5040\ \[Pi]\^2 + 1302\ \[Pi]\^4 + 320\ \[Pi]\^6 - 
                    7\ \[Pi]\^2\ \((360 + 120\ \[Pi]\^2 + 31\ \[Pi]\^4)\)\ 
                      x\^2 + 42\ \[Pi]\^4\ \((3 + \[Pi]\^2)\)\ x\^4 - 
                    3\ \[Pi]\^6\ x\^6)\) + 30240\ Sin[\[Pi]\ x])\)]\)], 
  "Input"],

Cell[BoxData[
    \(\(-\(1\/\(30240\ \[Pi]\^7\)\((
          x\ \((\(-15120\) - 5040\ \[Pi]\^2 - 1302\ \[Pi]\^4 - 
                320\ \[Pi]\^6 + 2520\ \[Pi]\^2\ x\^2 + 840\ \[Pi]\^4\ x\^2 + 
                217\ \[Pi]\^6\ x\^2 - 126\ \[Pi]\^4\ x\^4 - 
                42\ \[Pi]\^6\ x\^4 + 3\ \[Pi]\^6\ x\^6)\))\)\)\) + 
      Sin[\[Pi]\ x]\/\[Pi]\^8\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ \ Note\ that\ the\ functions\ \[Psi]1, \  ... , 
      \[Psi]5\ \n\t\tcan\ be\ easily\ eavaluated\ by\ 
        recursion . \ \n\t\ \ \ \ \ \ See\ recursion . nb\ in\ this\ 
        \(folder . \)\ \ *) \)], "Input"]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 509},
WindowMargins->{{4, Automatic}, {Automatic, -2}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 400, 9, 107, "Input"],
Cell[2142, 62, 82, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2261, 68, 417, 10, 142, "Input"],
Cell[2681, 80, 133, 2, 45, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2851, 87, 541, 12, 224, "Input"],
Cell[3395, 101, 224, 4, 44, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3656, 110, 846, 17, 222, "Input"],
Cell[4505, 129, 342, 6, 75, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4884, 140, 91, 1, 27, "Input"],
Cell[4978, 143, 38, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5053, 149, 151, 4, 42, "Input"],
Cell[5207, 155, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5299, 161, 210, 5, 65, "Input"],
Cell[5512, 168, 56, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5605, 174, 348, 9, 101, "Input"],
Cell[5956, 185, 57, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6050, 191, 446, 9, 121, "Input"],
Cell[6499, 202, 57, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6593, 208, 191, 5, 60, "Input"],
Cell[6787, 215, 56, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6880, 221, 245, 5, 85, "Input"],
Cell[7128, 228, 57, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7222, 234, 382, 9, 101, "Input"],
Cell[7607, 245, 57, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7701, 251, 492, 10, 141, "Input"],
Cell[8196, 263, 58, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8291, 269, 302, 6, 102, "Input"],
Cell[8596, 277, 57, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8690, 283, 428, 9, 105, "Input"],
Cell[9121, 294, 58, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9216, 300, 549, 11, 158, "Input"],
Cell[9768, 313, 59, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9864, 319, 567, 13, 155, "Input"],
Cell[10434, 334, 59, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10530, 340, 677, 14, 194, "Input"],
Cell[11210, 356, 59, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11306, 362, 292, 4, 107, "Input"],
Cell[11601, 368, 266, 4, 56, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11904, 377, 147, 4, 59, "Input"],
Cell[12054, 383, 140, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12231, 390, 50, 1, 27, "Input"],
Cell[12284, 393, 132, 2, 26, "Output"]
}, Open  ]],
Cell[12431, 398, 185, 3, 43, "Input"],

Cell[CellGroupData[{
Cell[12641, 405, 182, 4, 75, "Input"],
Cell[12826, 411, 171, 3, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13034, 419, 178, 3, 75, "Input"],
Cell[13215, 424, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13306, 430, 70, 1, 27, "Input"],
Cell[13379, 433, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13470, 439, 70, 1, 27, "Input"],
Cell[13543, 442, 54, 1, 26, "Output"]
}, Open  ]],
Cell[13612, 446, 399, 7, 91, "Input"],

Cell[CellGroupData[{
Cell[14036, 457, 525, 8, 171, "Input"],
Cell[14564, 467, 483, 8, 71, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15084, 480, 181, 4, 75, "Input"],
Cell[15268, 486, 183, 3, 41, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15488, 494, 52, 1, 27, "Input"],
Cell[15543, 497, 160, 2, 28, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15740, 504, 228, 5, 91, "Input"],
Cell[15971, 511, 220, 4, 41, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16228, 520, 103, 2, 43, "Input"],
Cell[16334, 524, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16425, 530, 67, 1, 27, "Input"],
Cell[16495, 533, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16586, 539, 67, 1, 27, "Input"],
Cell[16656, 542, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16747, 548, 68, 1, 27, "Input"],
Cell[16818, 551, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16909, 557, 403, 8, 102, "Input"],
Cell[17315, 567, 365, 6, 93, "Output"]
}, Open  ]],
Cell[17695, 576, 240, 4, 59, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

